import 'package:admin_desktop/domain/models/data/category_data.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/application/providers.dart';
import 'package:admin_desktop/infrastructure/constants/constants.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import '../../../../../../../theme/theme/theme.dart';
import '../riverpod/service/add/add_service_provider.dart';
import '../widgets/service_categories_modal.dart';

class AddServicePage extends ConsumerStatefulWidget {
  const AddServicePage({super.key});

  @override
  ConsumerState<AddServicePage> createState() => _AddServicePageState();
}

class _AddServicePageState extends ConsumerState<AddServicePage> {
  final _formKey = GlobalKey<FormState>();
  late TextEditingController title;
  late TextEditingController desc;
  late TextEditingController pause;
  late TextEditingController price;
  late TextEditingController interval;
  late TextEditingController category;
  CategoryData? selectCategory;

  @override
  void initState() {
    title = TextEditingController();
    desc = TextEditingController();
    pause = TextEditingController();
    price = TextEditingController();
    interval = TextEditingController();
    category = TextEditingController();
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      ref.read(addServiceProvider.notifier).clear();
      ref.read(addServiceProvider.notifier).setGender("all");
    });
  }

  @override
  void dispose() {
    title.dispose();
    desc.dispose();
    pause.dispose();
    price.dispose();
    interval.dispose();
    category.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    final state = ref.watch(addServiceProvider);
    final notifier = ref.read(addServiceProvider.notifier);
    return KeyboardDisable(
      child: CustomScaffold(
        body: (CustomColorSet colors) {
          return Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                children: [
                  BackButton(
                    onPressed: () {
                      ref.read(catalogueProvider.notifier).changeState(2);
                    },
                  ),
                  20.horizontalSpace,
                  Text(
                    AppHelpers.getTranslation(TrKeys.addServiceToMaster),
                    style: Style.interMedium(size: 20),
                  ),
                ],
              ),
              Expanded(
                child: SingleChildScrollView(
                  padding: REdgeInsets.symmetric(horizontal: 16),
                  physics: const BouncingScrollPhysics(),
                  child: Form(
                    key: _formKey,
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        16.verticalSpace,
                        MultiImagePicker(
                          imageUrls: state.listOfUrls,
                          listOfImages: state.images,
                          onImageChange: notifier.setImageFile,
                          onDelete: notifier.deleteImage,
                          isExtras: true,
                        ),
                        16.verticalSpace,
                        Row(
                          children: [
                            Expanded(
                              child: Column(
                                children: [
                                  OutlinedBorderTextField(
                                    label:
                                        '${AppHelpers.getTranslation(TrKeys.title)}*',
                                    textInputAction: TextInputAction.next,
                                    textController: title,
                                    validator: AppValidators.emptyCheck,
                                  ),
                                  8.verticalSpace,
                                  OutlinedBorderTextField(
                                    readOnly: true,
                                    onTap: () {
                                      AppHelpers.showAlertDialog(
                                        context: context,
                                        child: ServiceCategoriesModal(
                                          onChange: (value) {
                                            selectCategory = value;
                                            category.text =
                                                value.translation?.title ?? '';
                                          },
                                        ),
                                      );
                                    },
                                    label:
                                        "${AppHelpers.getTranslation(TrKeys.category)}*",
                                    textInputAction: TextInputAction.next,
                                    validator: AppValidators.emptyCheck,
                                    textController: category,
                                  ),
                                ],
                              ),
                            ),
                            12.horizontalSpace,
                            Expanded(
                              child: OutlinedBorderTextField(
                                label: AppHelpers.getTranslation(
                                    TrKeys.description),
                                textInputAction: TextInputAction.next,
                                textController: desc,
                                minLine: 6,
                              ),
                            ),
                          ],
                        ),
                        16.verticalSpace,
                        Row(
                          children: [
                            Expanded(
                              child: OutlinedBorderTextField(
                                label:
                                    '${AppHelpers.getTranslation(TrKeys.interval)}*',
                                textInputAction: TextInputAction.next,
                                textController: interval,
                                validator: AppValidators.isNumberValidator,
                                inputFormatters: [InputFormatter.digitsOnly],
                                inputType: TextInputType.number,
                              ),
                            ),
                            8.horizontalSpace,
                            Expanded(
                              child: OutlinedBorderTextField(
                                label:
                                    '${AppHelpers.getTranslation(TrKeys.pause)}*',
                                textInputAction: TextInputAction.next,
                                textController: pause,
                                validator: AppValidators.isNumberValidator,
                                inputFormatters: [InputFormatter.digitsOnly],
                                inputType: TextInputType.number,
                              ),
                            ),
                            8.horizontalSpace,
                            Expanded(
                              child: OutlinedBorderTextField(
                                label:
                                    '${AppHelpers.getTranslation(TrKeys.price)}(\$)*',
                                textInputAction: TextInputAction.next,
                                textController: price,
                                inputType: TextInputType.number,
                                validator: AppValidators.emptyCheck,
                                inputFormatters: [InputFormatter.currency],
                              ),
                            ),
                          ],
                        ),
                        16.verticalSpace,
                        Row(
                          children: [
                            Expanded(
                              child: OutlineDropDown(
                                label: TrKeys.type,
                                hint: TrKeys.type,
                                list: DropDownValues.serviceTypeList,
                                onChanged: notifier.setType,
                              ),
                            ),
                            12.horizontalSpace,
                            Expanded(
                              child: OutlineDropDown(
                                label: TrKeys.gender,
                                hint: TrKeys.all,
                                list: DropDownValues.genderList,
                                onChanged: notifier.setGender,
                              ),
                            ),
                          ],
                        ),
                        60.verticalSpace,
                        CustomButton(
                          width: 200,
                          textColor: Style.white,
                          // radius: 45,
                          title: AppHelpers.getTranslation(TrKeys.save),
                          isLoading: state.isLoading,
                          onTap: () {
                            if (state.images.isEmpty) {
                              AppHelpers.showSnackBar(
                                  context,
                                  AppHelpers.getTranslation(
                                      TrKeys.imageCantEmpty));
                              return;
                            }
                            if ((_formKey.currentState?.validate() ?? false) &&
                                selectCategory?.id != null) {
                              notifier.createService(
                                context,
                                created: (service) {
                                  AppHelpers.showSnackBar(
                                    context,
                                    AppHelpers.getTranslation(
                                        TrKeys.successfullyCreated),
                                  );
                                  // ref
                                  //     .read(serviceProvider.notifier)
                                  //     .fetchAllServices(
                                  //         context: context, isRefresh: true);
                                  ref
                                      .read(catalogueProvider.notifier)
                                      .changeState(2);
                                },
                                onError: () {},
                                title: title.text,
                                description: desc.text,
                                price: price.text,
                                interval: interval.text,
                                pause: pause.text,
                                categoryId: selectCategory!.id!,
                              );
                            }
                          },
                        ),
                        60.verticalSpace,
                      ],
                    ),
                  ),
                ),
              ),
            ],
          );
        },
      ),
    );
  }
}
